#pragma once
// ////////////////////////////////////////////////////////////////
// Common class for multiple interfaces.
// Sending and getting commands and responses are handled in the two functions:
//   SendCmd(Cstring cmd)
//   GetResponse(CString &response)
// Because of this the abstract base class is defined here. The classes for the different interfaces must be 
// inherited from this class
// 
// ////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "afxwin.h"
#include "afxcmn.h"

class CXlcio {
 private:
 public:
  	CString strName;
//
	CXlcio(void);
	virtual ~CXlcio(void)=0;
//
	virtual DWORD Close(void)=0;
	virtual int SendCmd(CString cmd) = 0;
	virtual int GetResponse(CString &response) = 0;
	virtual BOOL IsOpened( void )=0;
};
