//////////////////////////////////////////////////////////////////////////////////////////////
/// XLC4_DEMO.cpp : main application file
/// Description:	This project demonstrates how to communicate with the XLC4 commander via the serial interface <BR>
///
/// Author:			Sczech / CHROMASENS GmbH Konstanz <BR>
///
/// Date:			June, 03, 2014
//	Version:		1.0
//////////////////////////////////////////////////////////////////////////////////////////////
//
#include "stdafx.h"
#include <conio.h>

// Include the serial interface class to get an easy access to the XLC4 commander
#include "XLC4Serio.h"
#include "XLC4_DEMO.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

CWinApp theApp;

using namespace std;

//////////////////////////////////////////////////////////////////////////
/// Constants, global variables, etc.
//////////////////////////////////////////////////////////////////////////
HANDLE con=GetStdHandle(STD_OUTPUT_HANDLE);
const int ENABLED = 15;		// Menu item color for enabled items
const int DISABLED = 8;		// Menu item color for disabled items

// Position for response output
const int RESPONSE_Y_POS = 12;

//////////////////////////////////////////////////////////////////////////
// Clear the console
//////////////////////////////////////////////////////////////////////////
void clear() {
	COORD topLeft  = { 0, 0 };
	HANDLE console = GetStdHandle(STD_OUTPUT_HANDLE);
	CONSOLE_SCREEN_BUFFER_INFO screen;
	DWORD written;

	GetConsoleScreenBufferInfo(console, &screen);
	FillConsoleOutputCharacterA(
		console, ' ', screen.dwSize.X * screen.dwSize.Y, topLeft, &written
		);
	FillConsoleOutputAttribute(
		console, FOREGROUND_GREEN | FOREGROUND_RED | FOREGROUND_BLUE,
		screen.dwSize.X * screen.dwSize.Y, topLeft, &written
		);
	SetConsoleCursorPosition(console, topLeft);
}

//////////////////////////////////////////////////////////////////////////
// Sets the current position of the cursor
//////////////////////////////////////////////////////////////////////////
void gotoxy(int x,int y)
{
	COORD Coord;
	Coord.X=x;
	Coord.Y=y;

	SetConsoleCursorPosition(con,Coord);
}

//////////////////////////////////////////////////////////////////////////
// Set the text color
//////////////////////////////////////////////////////////////////////////
void textattr(int color)
{
	SetConsoleTextAttribute(con, color);
}

// Main program for the console application
int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	HMODULE hModule = ::GetModuleHandle(NULL);

	if (hModule != NULL)
	{
		// Init MFC 
		if (!AfxWinInit(hModule, NULL, ::GetCommandLine(), 0))
		{
			_tprintf(_T("Critical Error while initialising MFC\n"));
			nRetCode = 1;
		}
		else
		{
			// Create serial interface class
			CXLC4Serio serialIOClass;
			CString sendString(_T(""));
			CString rcvString(_T(""));

			// Open interface
			INT32 comNo=1;
			printf("please enter the desired COM-Port number to open:");
			scanf_s("%d",&comNo);
			CString serIF;
			serIF.Format(_T("COM%d"), comNo);
			DWORD initResult = serialIOClass.Open(serIF, 115200);

			if(initResult != ERR_SUCCESS)
			{
				printf("Error occurred opening serial interface: \n%S\n", serialIOClass.m_errMsg);
			}
			else
			{
				// Serial interface initialized successfully
				textattr(FOREGROUND_GREEN|FOREGROUND_INTENSITY);
				printf("Successfully opened serial interface: %S\n", serIF);

				// The delimiters for the start and the end of the command (STX and ETX are added by the serial interface class!)
				// Request the current Firmware version and release from the controller
				sendString.Format(_T("VR"));
				// Need to enclose the send and receive command into try/catch-blocks. Otherwise the program will crash in case of an error
				// The interface class throws exceptions!
				try{
					serialIOClass.SendCmd(sendString);
				}
				catch(CXLC4Rs232IoError rs232Err) {
					printf("Error sending command 'VR': %S", rs232Err.ioErrMsg);	
				}

				try{
					serialIOClass.GetResponse(rcvString);
				}
				catch(CXLC4Rs232IoError rs232Err) {
					printf("Error getting response 'VR': %S", rs232Err.ioErrMsg);	
				}
				printf("Received response: %S\n", rcvString);

				printf("Press key to start!\n");
				_getch();
				bool runSample = true;

				clear();
				while(runSample)
				{
					// Clear display
					gotoxy(0,0);
					textattr(ENABLED);
					printf("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
					printf("+   Sample program for interfacing the XLC4 light controller    +\n");
					printf("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
					printf("\n");
					printf("\n");
					printf("Please press the key for the desired function\n");
					printf("\n");
					printf("(0) Switch illumination off\n");
					printf("(1) Switch illumination on\n");
					printf("(q) Quit the sample program\n");
					printf("\n");

					int choice = _getch();

					switch(choice)
					{
					case '0':
						clear(); // Clear the display
						gotoxy(0, RESPONSE_Y_POS);

						// The delimiters for the start and the end of the command (STX and ETX are added by the serial interface class!)
						sendString.Format(_T("LC A 0"));
						// Need to enclose the send and receive command into try/catch-blocks. Otherwise the program will crash in case of an error
						// The interface class throws exceptions!
						try{
							serialIOClass.SendCmd(sendString);
						}
						catch(CXLC4Rs232IoError rs232Err) {
							printf("Error sending command 'LC A 0': %S", rs232Err.ioErrMsg);	
							break;
						}

						try{
							serialIOClass.GetResponse(rcvString);
						}
						catch(CXLC4Rs232IoError rs232Err) {
							printf("Error getting response 'LC A 0': %S", rs232Err.ioErrMsg);	
							break;
						}

						printf("Received response: %S\n", rcvString);
						break;
					case '1':
						clear(); // Clear the display
						gotoxy(0, RESPONSE_Y_POS);

						// The delimiters for the start and the end of the command (STX and ETX are added by the serial interface class!)
						sendString.Format(_T("IY A 200"));
						// Need to enclose the send and receive command into try/catch-blocks. Otherwise the program will crash in case of an error
						// The interface class throws exceptions!
						serialIOClass.SendCmd(sendString);
						try{
							serialIOClass.SendCmd(sendString);
						}
						catch(CXLC4Rs232IoError rs232Err) {
							printf("Error sending command 'IY A 200': %S", rs232Err.ioErrMsg);	
							break;
						}

						try{
							serialIOClass.GetResponse(rcvString);
						}
						catch(CXLC4Rs232IoError rs232Err) {
							printf("Error getting response 'LC A 0': %S", rs232Err.ioErrMsg);	
							break;
						}
						printf("\nReceived response: %S\n", rcvString);

						sendString.Format(_T("LC A 1"));
						try{
							serialIOClass.SendCmd(sendString);
						}
						catch(CXLC4Rs232IoError rs232Err) {
							printf("Error sending command 'LC A 1': %S", rs232Err.ioErrMsg);	
							break;
						}

						try{
							serialIOClass.GetResponse(rcvString);
						}
						catch(CXLC4Rs232IoError rs232Err) {
							printf("Error getting response 'LC A 0': %S", rs232Err.ioErrMsg);	
							break;
						}
						printf("Received response: %S\n", rcvString);
						break;
					case 'q':
						runSample = false;
						clear();

						break;
					}
				}

				// Finished, close interface again
				serialIOClass.Close();

			}
		}
	}
	else
	{
		_tprintf(_T("Critical error: error at GetModuleHandle.\n"));
		nRetCode = 1;
	}

	return nRetCode;
}
