//
// XLC4Serio.h : Headerfile
//
#pragma once

#include "afxwin.h"
#include "afxcmn.h"
#include "Xlcio.h"

#define ASCII_BEL       0x07
#define ASCII_BS        0x08
#define ASCII_LF        0x0A
#define ASCII_CR        0x0D
#define ASCII_XON       0x11
#define ASCII_XOFF      0x13

#define STX	0x02
#define ETX 0x03

#define RECEIVE_BUFFER_SIZE   1024
#define RESPONSE_LEN_MAX      512
#define WRITE_BUFFER_SIZE     256


typedef enum {
  ERR_SUCCESS				 = (0),
  ERR_FAILEDONCREATEFILE     = (-1001),
  ERR_FAILEDONSETCOMMTIMEOUT = (-1002),
  ERR_FAILEDONSETUPCOMM      = (-1003),
  ERR_FAILEDONGETCOMMSTATE   = (-1004),
  ERR_FAILEDONCLOSEHANDLE    = (-1005),
  ERR_WRITEFILETIMEDOUT      = (-1006),
  ERR_FAILEDONWRITFILE       = (-1007),
  ERR_DEVICENOTOPEN          = (-1008),
  ERR_READFILETIMEDOUT       = (-1009),
  ERR_READFILETIMEDOUT1      = (-1010),
  ERR_FAILEDONREADFILE1      = (-1011),
  ERR_FAILEDONREADFILE2      = (-1012),
  ERR_NORESPONSEFROMXLC      = (-1013),
  ERR_INVALIDRESPONSE        = (-1014)
}rs232ErrNum_t;


class CXLC4Serio : public CXlcio {
public:
	CXLC4Serio(void);
	~CXLC4Serio();

	DWORD Open( CString strComPort, int nBaud );
	DWORD Close( void );

    int SendCmd( CString strCommand );
	int GetResponse(CString &response);
	BOOL IsOpened( void );
	CString ErrorCodeToText(DWORD err);
                          //   Error information
    CString m_strDevice;
	CString m_errMsg;     //   
	rs232ErrNum_t  m_errNum;
	DWORD m_dwError;

protected:
	char m_recvBuffer[RECEIVE_BUFFER_SIZE];
	int m_recvRdIindex;
	int m_recvWrIindex;
	int m_recvFill;
	HANDLE m_hXLC4ComDev;
	OVERLAPPED m_OverlappedRead, m_OverlappedWrite;
	BOOL m_bOpened;
//
	int ReadInputData( const char *, int );
	int ReadDataWaiting( void );
	BOOL Write1Byte( unsigned char );
};


////////////////////////////////////////////////////////////////////
//
//  Error-class for the RS232-functions
////////////////////////////////////////////////////////////////////
class CXLC4Rs232IoError{
public:
	CXLC4Rs232IoError(rs232ErrNum_t xlcErr, DWORD dwCommErr, CString msg);

	rs232ErrNum_t xclError;        // Error number of programm situation ERR_...
	int dwCommErr;       // Error code on communication device
	CString ioErrMsg;
};