#include "StdAfx.h"
//#include <windows.h>
#include <iostream>
//#include "XLC4CommanderDlg.h"
#include "XLC4Tcpio.h"
#include "HresTimer.h"

////////////////////////////////////////////////////////////////////////////////////
// Konstruktor
///////////////////////////////////////////////////////////////////////////////////
CXLC4Tcpio::CXLC4Tcpio(void)
{
  strName = _T("Tcp");
  m_bOpened = FALSE;
  m_recvbuflen = DEFAULT_BUFLEN;
  m_wsaErrCode = 0;
}

CXLC4Tcpio::~CXLC4Tcpio(void)
{
	Close();
}

BOOL CXLC4Tcpio::IsOpened( void ){
	return( m_bOpened );
}


//////////////////////////////////////////////////////////////////////////////////////
// sendXlcData( ... )                                                               //
// ----------------------------------------------------------------------------     //
// Does send Data to the XLC4 via the opened socket connection m_ConnectSocket      //
// Parameter:                                                                       //
//      [in]  BYTE *pBuffer             buffer to be sent out                       //
//      [in]  const int nBufLen         length of buffer                            //
//      [out] int &bytesToSend           number of bytes sent                       //  
//      [in]  unsigned int nTimeout     time limit  in milliseconds                 //
//                                                                                  //
//          //
//////////////////////////////////////////////////////////////////////////////////////
int CXLC4Tcpio::sendXlcData(char *pBuffer, const int nBufLen, int &bytesToSend, unsigned int nTimeout)
{
  int bytesSent;
  int iResult;
  int hardLimit;
  unsigned int deltaT;

  if( bytesToSend + 2 < nBufLen) {
    pBuffer[bytesToSend++] = '\r';
    pBuffer[bytesToSend++] = '\n';
	pBuffer[bytesToSend] = '\0';   
  } else {
	  return ERR_SENDBUFSIZE;
  }

  m_wsaErrCode = 0;
  stopWatch.SetStartTime();  // T=0
  hardLimit = 1000;          // in case the system has no high reolution performance counter
//                           // avoid endless loop 
  bytesSent = 0;
  do {
    iResult = send(m_ConnectSocket, pBuffer+bytesSent, bytesToSend-bytesSent,0);
    m_wsaErrCode = WSAGetLastError();  // Error or ... 
	if( iResult == 0 ) {
	   return ERR_CONNECTIONCLOSED;    // connection has been closed
    }
	if( iResult == SOCKET_ERROR && m_wsaErrCode != WSAEWOULDBLOCK) {
       return ERR_SEND;                 
	}
	if(iResult >0) {
		bytesSent += iResult;
	    if( bytesSent == bytesToSend ) return ERR_SUCCESS; // all bytes delivered    
	}
	Sleep(10);
	hardLimit--;
	deltaT = stopWatch.getDeltaT_millisecs();
  } while( deltaT < nTimeout && hardLimit > 0);
  return ERR_SENDTIMEOUT; 
}

/////////////////////////////////////////////////////////////////////////////////////
// Implementation of SendCmd
// ----------------------------
// Convert XLC4-command from typt CString to ASCII bytes , 
// for telnet append "\r\n" before sending
// Timeout = 2000ms
/////////////////////////////////////////////////////////////////////////////////////
int CXLC4Tcpio::SendCmd( CString strCommand )
{
	USES_CONVERSION;
    int iResult;
 	if( !m_bOpened ) return ERR_NOTCONNECTED;
    CString strCmd;

	strCmd.Format(_T("\002%s\003"),strCommand); // Send Frame STX.....ETX
	int size = strCmd.GetLength();
    CW2A byteBuffer(strCmd);
	strcpy_s(sendbuf,DEFAULT_BUFLEN, byteBuffer);
    iResult = sendXlcData( sendbuf, DEFAULT_BUFLEN, size, 2000); // timlimit 2 seconds
    if(iResult != ERR_SUCCESS ) {
	   m_errMsg.Format(_T("++ IO-Error %d thrown: SendCmd failed with WSA error code %ld"), iResult, m_wsaErrCode);
	   CXLC4TcpIoError tcpErr((tcpErrNum_t)iResult, m_wsaErrCode, m_errMsg);
       throw tcpErr;  // Errorcode
	 }
  	return iResult;
}

//////////////////////////////////////////////////////////////////////////////////////
// receiveXlcData( ... )                                                            //
// ----------------------------------------------------------------------------     //
// Reads data from the opened connection m_ConnectSocket                 //
// Parameter:                                                                       //
//      [in]  BYTE *pBuffer             buffer to receive the data                  //
//      [in]  const int nBufLen         length of buffer                            //
//      [out] int &bytesRead            number of bytes read                        //  
//      [in]  unsigned int nTimeout     time limit  in milliseconds                 //
//                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////
int CXLC4Tcpio::receiveXlcData(char *pBuffer, const int nBufLen, int &bytesRead, unsigned int nTimeout)
{
  int iResult;
  int hardLimit;

  bytesRead = 0;
  m_wsaErrCode = 0;
  stopWatch.SetStartTime();  // T=0
  hardLimit = 1000;          // in case the system has no high reolution performance counter
  unsigned int deltaT;

//
  do {
    iResult = recv(m_ConnectSocket,pBuffer+bytesRead, nBufLen-bytesRead,0);
    m_wsaErrCode = WSAGetLastError();  // Error or ... 
	if( iResult == 0 ) {
       return ERR_CONNECTIONCLOSED;                   // connection has been closed
	}
	if( iResult == SOCKET_ERROR && m_wsaErrCode != WSAEWOULDBLOCK) {
	   return ERR_RECV;
	}
	if( iResult > 0) {
      bytesRead += iResult;
	  if( nBufLen - bytesRead <= 0 ) {
		 return ERR_RECVOVERFLOW;
	  }
//                                 iResult > 0   telegram or part of it was read
//                                 look if commplete (".....\r\n")

      if( pBuffer[bytesRead-1] == '>' && pBuffer[bytesRead-2] == '>' &&
		  pBuffer[bytesRead-3] == '\n'  && pBuffer[bytesRead-4] == '\r') {
	      pBuffer[bytesRead-4] = '\0';
          bytesRead -= 4;
	      return ERR_SUCCESS;              // "normales"  Telegram complete 
	  }
      if( pBuffer[bytesRead-1] == '\n' && pBuffer[bytesRead-2] == '\r') {
	    pBuffer[bytesRead-2] = '\0'; 
		bytesRead -= 2;                  // bei disconnect "Goodbye!8,28" ?
	    return ERR_SUCCESS;              // "normal"  Telegram complete 
	  }
	  if( pBuffer[bytesRead-2] == ':' && pBuffer[bytesRead-1] == ' ') {
	    pBuffer[bytesRead-2] = '\0'; 
		bytesRead -= 2;
	    return ERR_SUCCESS;              // Telnet Login/Passwort Prompt
	  }
	  if( pBuffer[bytesRead-2] == '>' && pBuffer[bytesRead-1] == '>') {
	    pBuffer[bytesRead-2] = '\0'; 
		bytesRead -= 2;
	    return ERR_SUCCESS;              // Telnet Login/Passwort Prompt
	  }
	}
    Sleep(10);
	hardLimit--;
	deltaT=stopWatch.getDeltaT_millisecs();
  } while( deltaT < nTimeout && hardLimit > 0);
  return ERR_RECVTIMEOUT;
}

/////////////////////////////////////////////////////////////////////////////////////
// Implementation of GetResponse
// -------------------------------
// Receiving of possible partial strings, append until ETX was received
//
/////////////////////////////////////////////////////////////////////////////////////
int CXLC4Tcpio::GetResponse(CString &response)
{
  
  CString s;
  int bytesRead;
  response.Empty();
  int iResult;
  int xlcErrno;


  // read XLC4 response or at least first junk of it
  iResult = receiveXlcData(recvbuf, m_recvbuflen, bytesRead, 3000);
  if(iResult != ERR_SUCCESS) {
	 m_errMsg.Format(_T("++ Error %d: reading data from XLC4, last IO error %ld"), iResult, m_wsaErrCode);
     xlcErrno = ERR_GETRESPONSE;
  }
  else if( recvbuf[0] != 0x02 ) {
 	 m_errMsg.Format(_T("++ Error %d: reading data from XLC4, last IO error %ld"), iResult, m_wsaErrCode);
     xlcErrno = ERR_NOSTXFRAME;
  }
  else if(recvbuf[bytesRead-1] == 0x03 ) {
 	 m_errMsg.Format(_T(">> XLC4 Response complete 4, last IO error %ld"), iResult, m_wsaErrCode);
     recvbuf[bytesRead-1] = '\0';
     response.Format(_T("%s"),CString(&recvbuf[1]));
     xlcErrno = ERR_SUCCESS;
  }
  else {
      int junkCtr = 100;  
	do {
      junkCtr--;
      if(junkCtr <= 0) {
        xlcErrno = ERR_RESPONSEINCOMPLETE;
	    break;
      }
     // read XLC4 response or at least a junk of it, bytesRead wird in receiveXlcData =0 gesetzt, weil Referenz 
      iResult = receiveXlcData(recvbuf+bytesRead, m_recvbuflen-bytesRead, bytesRead, 3000);
      if(iResult != ERR_SUCCESS) {
	    m_errMsg.Format(_T("++ Error %d: reading data from XLC4, last IO error %ld"), iResult, m_wsaErrCode);
        xlcErrno = ERR_GETRESPONSE;
	    break;
      }
      else if( recvbuf[bytesRead+bytesRead-1] == 0x03 ) {
 	    m_errMsg.Format(_T(">> XLC4 Response complete 4, last IO error %ld"), iResult, m_wsaErrCode);
        recvbuf[bytesRead-1] = '\0';
        response.Format(_T("%s"),CString(&recvbuf[1]));
	    xlcErrno = ERR_SUCCESS;
        break;
      }
      m_bytesRead += bytesRead;
    } while(junkCtr);
  }

  if( xlcErrno != ERR_SUCCESS) {
    m_errMsg.Format(_T("++ IO-Error %d thrown: GetResponse failed with error code %ld"), xlcErrno, m_wsaErrCode);
    CXLC4TcpIoError tcpErr((tcpErrNum_t)xlcErrno, m_wsaErrCode, m_errMsg);
    throw tcpErr;  // Errorcode
  }
  return ERR_SUCCESS;
}



/////////////////////////////////////////////////////////////////////////////////
// O p e n ("192.168.87.234", 23, CString &errMsg)
// ------------------------------------------------------------------------
//  Establishes a telnet connection to an XLC4-device
//  Open(ipHostAddr,port) or  Open(ipHostName,port)
//  Return value   == 0 --> connection establised
//                 > 0  --> error code from call to WSAGetLastError()
//                 < 0  --> other causes than network trouble
// ////////////////////////////////////////////////////////////////////////////
int CXLC4Tcpio::Open( CString xlcNameOrAddr, int PortNum)
{
  int bytesToSend;
  int bytesRead;
//  unsigned int addr;
 // hostent* pXlcHost;
  int iResult;
 // int iRetry;
  char *p;
  char *next;


// High Resolution Performance Counter Frequenz ermitteln
// verwendet fr Zeitberwachungen bei Sockets in nonblocking mode
	if( stopWatch.HresTimerInitialize(m_HrCounterResolution, m_nulltime) < 0) {
	  m_errMsg.Format(_T("-> No high resolution performance counter in this system."));
      return ERR_NOHIGHRESCOUNTER;
	}
//
// Now Initialize Winsock library
// ------------------------------
  iResult = WSAStartup(MAKEWORD(2,2), &m_WsaData);
  if (iResult != 0) {
      m_wsaErrCode = WSAGetLastError();
      m_errMsg.Format(_T("++ WSAStartup failed with error code %d"),m_wsaErrCode);
	  return ERR_WSASTARTUP;
  }
  m_strIPv4HostAddr = xlcNameOrAddr;   // vorerst sind keine Hostnamen zu verwenden
  CW2A szHost(xlcNameOrAddr);          // kein DHCP
  strcpy_s(m_cXlcIPv4, 20, szHost);     // als einfaches char[]
/*
// What was specified via Tcp/configure host name or IPv4 address?
  if (isalpha(szHost[0]))  {   // looks like a name
    pXlcHost = gethostbyname(szHost);
    if(pXlcHost == NULL) {
      m_wsaErrCode = WSAGetLastError();
	  m_errMsg.Format(_T("++ No IPv4 address found for %s, error code %d"),CString(szHost),m_wsaErrCode);
	  return ERR_NOIPADDRFOUND;
    }
  }
  else
  { 
    addr = inet_addr(szHost);
    pXlcHost = gethostbyaddr((char *)&addr, 4, AF_INET);
    if(pXlcHost == NULL) {
      m_wsaErrCode = WSAGetLastError();
	  m_errMsg.Format(_T("++ Could not locate host on %s, error code %d"),CString(szHost),m_wsaErrCode);
	  return ERR_COULDNOTLOCATE;
    }
    strcpy_s(m_cXlcIPv4, 20, inet_ntoa (*(struct in_addr *)*pXlcHost->h_addr_list));
  }
*/
// Now build the socket
// -------------------------
  m_ConnectSocket = socket(AF_UNSPEC, SOCK_STREAM, IPPROTO_TCP);
  if (m_ConnectSocket == INVALID_SOCKET) {
     m_wsaErrCode = WSAGetLastError();
	 m_errMsg.Format(_T("++ Could not create socket, error code %d"),m_wsaErrCode);
     WSACleanup();
	 return ERR_CREATESOCKET;
  }

  //----------------------
  // The sockaddr_in structure specifies the address family,
  // IP address, and port of the server to be connected to.
   sockaddr_in clientService; 
   clientService.sin_family = AF_INET;
//   clientService.sin_addr.s_addr = inet_addr(m_cXlcIPv4);
   clientService.sin_addr.s_addr = inet_addr(szHost);
   clientService.sin_port = htons( PortNum );

 //----------------------
 // Now try to connect to server.
   if ( connect( m_ConnectSocket, (SOCKADDR*) &clientService, sizeof(clientService) ) == SOCKET_ERROR) {
     m_wsaErrCode = WSAGetLastError();
	 m_errMsg.Format(_T("++ Could not connect to XLC on %s, error code %d"), CString(m_cXlcIPv4), m_wsaErrCode);
     WSACleanup();
	 return ERR_SOCKETCONNECT;
   }  
/*
   for(iRetry=0; iRetry<5; iRetry++)
   {
     iResult = connect( m_ConnectSocket, (SOCKADDR*) &clientService, sizeof(clientService) );
	 if(iResult==0) {
		 iRetry = 0;
		 break;   // Vebindung steht -->>
	 }
     m_wsaErrCode = WSAGetLastError();
	 if(iResult ==SOCKET_ERROR && m_wsaErrCode!=WSAEWOULDBLOCK && m_wsaErrCode!=WSAETIMEDOUT
		                       && m_wsaErrCode!=WSAENETUNREACH && m_wsaErrCode!=WSAECONNABORTED
	 )
	 {
	   m_errMsg.Format(_T("++ Could not connect to XLC on %s, error code %d"), CString(m_cXlcIPv4), m_wsaErrCode);
       WSACleanup();
	   return ERR_SOCKETCONNECT;
	 }
	 Sleep(1000);
   } 
   if(iRetry > 0)
   {
	   m_errMsg.Format(_T("++ Could not connect to XLC, Retry=%d, IP=%s, error code %d"),
		                                                  iRetry,CString(m_cXlcIPv4), m_wsaErrCode);
       WSACleanup();
	   return ERR_SOCKETCONNECT;
   }
*/
   // Set socket into nonblocking mode
   // ---------------------------------
	unsigned long iMode = 1;
	iResult = ioctlsocket(m_ConnectSocket, FIONBIO, &iMode);
	if (iResult != 0)
	{	
       m_wsaErrCode = WSAGetLastError();
	   m_errMsg.Format(_T("++ ioctlsocket failed with error: %ld errorCode %ld\n"), iResult, m_wsaErrCode);
       WSACleanup();
	   return ERR_SETTONONBLOCKING;
	}

   // What now follows is telenet gossip for the Login dialog: Username & password
   // -------------------------------------------------------------------------
   // XLC emmits a message as login prompt that shows user and password...
   //   Microchip Telent Server 1.1.
   //   Type 'admin' for the login and 'chromasens' for the password
   //   0x27 for Apostroph
   iResult = receiveXlcData(recvbuf, m_recvbuflen, bytesRead, 5000);
   if ( iResult == ERR_SUCCESS) {
	   if((p = strtok_s(recvbuf, "'",&next))!=NULL) {
	     p = strtok_s(NULL, "'",&next);
		 strncpy_s(m_telnetUser,32,p,30);
		 if(p!=NULL) {
			 if((p = strtok_s(NULL,"'",&next))!= NULL) { 
		       p = strtok_s(NULL,"'",&next);
               strncpy_s( m_telnetPassword,32, p,30);
		     }
			 else {
			   strncpy_s(m_telnetUser,DEFAULT_BUFLEN, DEFAULT_TELNET_USER,strlen(DEFAULT_TELNET_USER));
               strncpy_s(m_telnetPassword,DEFAULT_BUFLEN, DEFAULT_TELNET_PASSWORD, strlen(DEFAULT_TELNET_PASSWORD));
			 }
		 }
	   }
	   else {
		 m_errMsg.Format(_T("++ Error %d: Username/Passwrd too long, telnet login failed"), iResult);
         WSACleanup();
         return ERR_TELNETLOGIN1;
	   }
   }
   else {
	 m_errMsg.Format(_T("++ Error %d: reading telnet login prompt failed with error code %ld"), iResult, m_wsaErrCode);
     WSACleanup();
     return ERR_TELNETLOGIN1;
   }
   // send user name for login... get rid of the prompt for password
   bytesToSend = (int)strlen(m_telnetUser);
   iResult = sendXlcData(m_telnetUser, USERNAME_BUFLEN, bytesToSend, 2000);
   if(iResult != ERR_SUCCESS ) {
	   m_errMsg.Format(_T("++ Error %d: sending user name for telnet login, failed with error code %ld"), iResult, m_wsaErrCode);
       WSACleanup();
       return ERR_TELNETLOGINPUSER;
   }
   // discard prompt for password
   iResult = receiveXlcData(recvbuf, m_recvbuflen, m_bytesRead, 5000);
   if(iResult != ERR_SUCCESS) {
	 m_errMsg.Format(_T("++ Error %d: reading telnet password prompt, failed with error code %ld"), iResult, m_wsaErrCode);
     WSACleanup();
     return ERR_TELNETLOGIN2;
   }
   // send password for login... 
   bytesToSend = (int)strlen(m_telnetPassword);
   iResult = sendXlcData(m_telnetPassword, PASSWORD_BUFLEN, bytesToSend, 2000);
   if(iResult != ERR_SUCCESS ) {
	  m_errMsg.Format(_T("++ Error %d: sending password for telnet login, failed with error code %ld"), iResult, m_wsaErrCode);
      WSACleanup();
      return ERR_TELNETLOGINPW;
   }
   // Logged in Sucessfully...
   // Input your command. Press 'q<Enter>' to quit. Kein Endekriterium
   iResult = receiveXlcData(recvbuf, m_recvbuflen, m_bytesRead, 2000);
   if(iResult != ERR_SUCCESS && iResult != ERR_RECVTIMEOUT) {
	 m_errMsg.Format(_T("++ Error %d: reading telnet password prompt, failed with error code %ld"), iResult, m_wsaErrCode);
     WSACleanup();
     return ERR_TELNETLOGIN3;
   }
   m_bOpened = TRUE;
   m_errMsg.Format(_T(">> Sucessfully logged in on XLC4 telent session")); 
   return ERR_SUCCESS;
}
///////////////////////////////////////////////////////////////////////////
//  Close()
//  ---------
////////////////////////////////////////////////////////////////////////////////
DWORD CXLC4Tcpio::Close( void )
{
   // sende "q\r\n" an XLC4, gibt es darauf noch eine Antwort???
   char quitTelnet[10] = "q"; 
   int bytesToSend;
   int buflen;
   int iResult;

   if( m_bOpened )
   {
   
     bytesToSend = 1;
     buflen = 10;
     iResult = sendXlcData(quitTelnet, buflen, bytesToSend, 2000);
     if(iResult != ERR_SUCCESS ) {
	    m_errMsg.Format(_T("++ Error %d: failed to end telnet session for (q for quit), error code %ld"), iResult, m_wsaErrCode);
        closesocket(m_ConnectSocket);
        WSACleanup();
        return ERR_QUITTELNET;
     }

//  
     iResult = shutdown(m_ConnectSocket, SD_SEND);
     if (iResult == SOCKET_ERROR) {
	    m_errMsg.Format(_T("++ Error %d: failed to shutdown socket, error code %ld"), iResult, m_wsaErrCode);
        closesocket(m_ConnectSocket);
        WSACleanup();
        return ERR_WSASHUTDOWN;
     }
// 
     m_recvbuflen = DEFAULT_BUFLEN;
     m_bytesRead = 0;
     iResult = receiveXlcData(recvbuf, m_recvbuflen, m_bytesRead, 2000);
     if(iResult != ERR_SUCCESS && iResult != ERR_RECVTIMEOUT) {
	   m_errMsg.Format(_T("++ Error %d: emptiing recv queue, error code %ld"), iResult, m_wsaErrCode);
       WSACleanup();
       return ERR_CLOSERECV;
     }
/////////////////////////////////
	 Sleep(300);
     closesocket(m_ConnectSocket);
     WSACleanup();
	 m_bOpened = FALSE;
   }
   return ERR_SUCCESS;
}

////////////////////////////////////////////////////////////////////
// Constructor for error class
////////////////////////////////////////////////////////////////////
CXLC4TcpIoError::CXLC4TcpIoError(tcpErrNum_t xlcErr, int wsaErr, CString msg)
{
    xclError = xlcErr;      // Error number of programm situation ERR_...
	wsaErrorCode = wsaErr;  // Windows Socket API errors
	ioErrMsg = msg;
}
