#pragma once
//#include "windows.h"
#include "stdio.h"
#include <string>
#include <iostream>
#include <atlstr.h>
#include "math.h"


///////////////////////////////////////////////////////////////////////////////////////////////
//  CHresTimer      High Resolution Timer                                                                     
//  -------------------------------------
//  Autor: Dihlmann
//  Die Klasse CHresTimer realisiert eine Stop-Uhr mit Zwischenzeiten.
//
//  HresTimerInitialize()  - ermittelt die Frequenz des High Resolution Performance counters
//  SetStartTime()         - Setzt den Startzeitpunkt
//  getDeltaT_microsecs()  - gibt die Zeit seit dem Startzeitpunkt in Mikrosekunden
//  getDeltaT_millisecs()  - gibt die Zeit seit dem Startzeitpunkt in Millisekunden
/////////////////////////////////////////////////////////////////////////////////////////////  
using namespace std;

class CHresTimer
{
 public:
	CHresTimer(void);
	~CHresTimer(void);

    int  HresTimerInitialize(double &resolution, double &nulltime);
    void SetStartTime(void);
    double  getDeltaT_microsecs(void);
    unsigned int getDeltaT_millisecs(void);

//
	CString m_errMsg;
	LONGLONG m_Frequency;
	double m_nulltime;

private:
    LONGLONG m_FirstNullCtrValue;  // time consumed for owen code
    LONGLONG m_LastNullCtrValue;
    LONGLONG m_StartCtrValue;      // Start time
    LONGLONG m_actualCtrValue;     // Stop time
};

