#include "StdAfx.h"
#include "HresTimer.h"


//  Konstruktor
CHresTimer::CHresTimer(void)
{
  m_Frequency = 0;
  m_FirstNullCtrValue = 0;
  m_LastNullCtrValue = 0;
  m_StartCtrValue = 0;
  m_actualCtrValue  = 0 ;
  m_nulltime = 0;
}


// Destruktor
CHresTimer::~CHresTimer(void)
{
}


int CHresTimer::HresTimerInitialize(double &resolution, double &nulltime)
{

    //Frequenz holen
    if (!QueryPerformanceFrequency((LARGE_INTEGER*)&m_Frequency)) {
        m_errMsg.Format(_T("++ Performance Counter nicht vorhanden,Fehler %d"),GetLastError());
	    return -1;
	}
	resolution = 1000000 / ((double)m_Frequency);
	//null-messung
	QueryPerformanceCounter((LARGE_INTEGER*)&m_FirstNullCtrValue);
	QueryPerformanceCounter((LARGE_INTEGER*)&m_LastNullCtrValue);
	m_nulltime = (((double)(m_LastNullCtrValue-m_FirstNullCtrValue))/((double)m_Frequency)); 
//
//  Zeitunkt der Konstuktion als Default-Startzeitpunkt festlegen
	QueryPerformanceCounter((LARGE_INTEGER*)&m_StartCtrValue);
    return 0;
}

void  CHresTimer::SetStartTime(void)
{
		//begin counting
	QueryPerformanceCounter((LARGE_INTEGER*)&m_StartCtrValue);
}

double  CHresTimer::getDeltaT_microsecs(void)
{
		//2nd reading
    QueryPerformanceCounter((LARGE_INTEGER*)&m_actualCtrValue);

    double dTimeDiff = (((double)(m_actualCtrValue-m_StartCtrValue))/((double)m_Frequency)); 

	//Von der gemessenen Zeit die "Null-Zeit" abziehen, um genauer zu werden
	double time = (dTimeDiff - m_nulltime) * 1000000; //mikro-sekunden
	return time;
}


unsigned int CHresTimer::getDeltaT_millisecs(void)
{
		//2nd reading
	double tmikro;
    unsigned int tmilli;

    QueryPerformanceCounter((LARGE_INTEGER*)&m_actualCtrValue);
    double dTimeDiff = (((double)(m_actualCtrValue-m_StartCtrValue))/((double)m_Frequency)); 

	//Von der gemessenen Zeit die "Null-Zeit" abziehen, um genauer zu werden
	tmikro = (dTimeDiff - m_nulltime) * 1000000;  //mikro-sekunden
	tmilli = (unsigned int)( (tmikro+500.0)/1000.0 );            // milli-skunden
	return tmilli;
}

