﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.IO.Ports;
using System.IO;

namespace XLC4_CSharp
{
    class Program
    {

        static void Main(string[] args)
        {
        // -- Byte values of commands --
        byte[] STX = new byte[] { 0x02 };
        byte[] ETX = new byte[] { 0x03 };
        SerialPort theSerialPort = new SerialPort();
            theSerialPort.Parity = Parity.None;
            theSerialPort.BaudRate = 115200;
            theSerialPort.DataBits = 8;
            theSerialPort.StopBits = StopBits.One;
            theSerialPort.PortName = "COM1";

            Console.WriteLine("\nTry to open COM-Port!");
            try
            {
                theSerialPort.Open();
            }
            catch (Exception e)
            {
                Console.WriteLine("Error" + e, "Error\nPress Key to terminate!");
                System.Console.ReadKey();
                return;
            }

            string sendString;
            sendString = "LC 1";
            // Send STX to indicate the start of the frame
            theSerialPort.Write(STX, 0, 1);
            // Send the desired command to the XLC4
            theSerialPort.Write(sendString);
            // Send ETX to indicate the end of the frame
            theSerialPort.Write(ETX, 0, 1);

            // Simply wait some time to get the response -> To do this correctly implement a seperate receiving thread
            Thread.Sleep(500);
            string receiveString;
            receiveString = theSerialPort.ReadExisting();
            Console.WriteLine("\nRead: " + receiveString);

            Thread.Sleep(5000);
            sendString = "LC 0";

            // Send STX to indicate the start of the frame
            theSerialPort.Write(STX, 0, 1);
            // Send the desired command to the XLC4
            theSerialPort.Write(sendString);
            // Send ETX to indicate the end of the frame
            theSerialPort.Write(ETX, 0, 1);

            // Simply wait some time to get the response -> To do this correctly implement a seperate receiving thread
            Thread.Sleep(500);
            receiveString = theSerialPort.ReadExisting();
            Console.WriteLine("\nRead: " + receiveString);

            Console.WriteLine("\nFinished!");
            System.Console.ReadKey();
        }
    }
}
