#!/bin/bash

# echo "==============================="
# echo "Welcome to Uninstall SVCamKit"
# echo "==============================="

function check() {
	if [ $? == 0 ]; then
		:
	else
		echo "... not ok"
		exit 1
	fi
}

oldpath=$(pwd)

if (($EUID != 0)); then
	pkexec "$oldpath"/SVCam_Kit_Uninstall_Linux.sh "$oldpath"
	check

	if [ -d ~/.config/SVS-VISTEK\ GmbH ]; then
		rm -rf ~/.config/SVS-VISTEK\ GmbH
		check
	fi

	if [ -d ~/Documents/SVCapture ]; then
		rm -rf ~/Documents/SVCapture
		check
	fi

	if [ -f ~/Desktop/SVCapture64.desktop ]; then
		rm ~/Desktop/SVCapture64.desktop
	fi

	exit
fi

svpath="$1"

echo "Uninstalling ..."
if [ -f /etc/udev/rules.d/60-svcamkit-u3v.rules ]; then
	rm /etc/udev/rules.d/60-svcamkit-u3v.rules
	check
fi

if [ -f /etc/systemd/system/svcamkit_u3v_startup.service ]; then
	systemctl disable svcamkit_u3v_startup.service
	check
	rm /etc/systemd/system/svcamkit_u3v_startup.service
	check
fi

if [ -f /etc/systemd/svcamkit_u3v_startup.sh ]; then
	rm /etc/systemd/svcamkit_u3v_startup.sh
	check
fi

if [ -f /etc/sysctl.d/60-svcamkit-gev.conf ]; then
	rm /etc/sysctl.d/60-svcamkit-gev.conf
	check
fi

if [ -f /usr/share/polkit-1/actions/com.svsvistek.pkexec.svipconfig.policy ]; then
	rm /usr/share/polkit-1/actions/com.svsvistek.pkexec.svipconfig.policy 
	check
fi

if [ -d /opt/SVS ]; then
	rm -rf /opt/SVS
	check
fi

if [ -f /etc/ld.so.conf.d/svcamkit.conf ]; then
	rm /etc/ld.so.conf.d/svcamkit.conf
	check
	ldconfig
	check
fi

if [ -f /etc/environment ]; then
	cp /etc/environment /etc/environment_$(date +"%Y%m%d_%H%M%S")
	check
fi

sed -i -e '/^SVS_GENICAM_CACHE/d' -e '/^SVS_SDK_BIN_64/d' -e '/^GENICAM_GENTL64_PATH/d' /etc/environment
check

if [ -L /usr/local/bin/SVCapture64 ]; then
	rm /usr/local/bin/SVCapture64
fi

if [ -L /usr/local/bin/SVIPConfig-x86_64 ]; then
	rm /usr/local/bin/SVIPConfig-x86_64
fi

echo "SVCamKit is uninstalled successfully!"
echo "Please reboot the pc!"
echo
