#include "SVCamFeature.h"
#include <cstring>

SVCamFeature::SVCamFeature(SV_REMOTE_DEVICE_HANDLE hRemoteDevice)
{
    m_hRemoteDevice = hRemoteDevice;
}

SVCamFeature::~SVCamFeature()
{
    for (std::vector <SVCamFeatureInfo*>::iterator it = m_featureInfolist.begin(); it != m_featureInfolist.end(); ++it )
    {
        UnRegisterInvalidateCB((*it)->hFeature);
    }
    DSDeleteContainer(m_featureInfolist);
}

void SVCamFeature::getFeatureValue(SV_FEATURE_HANDLE hFeature, SVCamFeatureInfo *svCamfeatureInfo)
{
    SVFeatureGetInfo(m_hRemoteDevice, hFeature, &svCamfeatureInfo->featurInfo);

    memset(svCamfeatureInfo->strValue, 0, sizeof(char)*SV_STRING_SIZE);
    memset(svCamfeatureInfo->subFeatureName, 0, sizeof(char)*SV_STRING_SIZE);

    if(SV_intfIInteger == svCamfeatureInfo->featurInfo.type)
    {
        int64_t value = 0;
        SVFeatureGetValueInt64(m_hRemoteDevice, hFeature, &value);
        svCamfeatureInfo->intValue = value;

        if (svCamfeatureInfo->featurInfo.intInc == 0)
            svCamfeatureInfo->featurInfo.intInc = 1;

        std::string st = std::to_string( value);
        st.copy( svCamfeatureInfo->strValue, SV_STRING_SIZE);
    }
    else if(SV_intfIFloat == svCamfeatureInfo->featurInfo.type)
    {
        double value = 0.0f;
        SVFeatureGetValueFloat(m_hRemoteDevice, hFeature, &value);

        if (svCamfeatureInfo->featurInfo.floatInc == 0)
            svCamfeatureInfo->featurInfo.floatInc = 1.0;

        svCamfeatureInfo->doubleValue = value;
        std::to_string( value).copy(svCamfeatureInfo->strValue, SV_STRING_SIZE);
    }
    else if(SV_intfIBoolean == svCamfeatureInfo->featurInfo.type)
    {
        bool value = false;
        SVFeatureGetValueBool(m_hRemoteDevice, hFeature, &value);
        svCamfeatureInfo->booValue = value;
        if ( value ==0)
        {
            std::string s("False");
            s.copy(svCamfeatureInfo->strValue, SV_STRING_SIZE);
        }
        else
        {
            std::string s("True");
            s.copy(svCamfeatureInfo->strValue, SV_STRING_SIZE);
        }
    }
    else if(SV_intfICommand == svCamfeatureInfo->featurInfo.type)
    {
        std::string s(" = > Execute Command");
        s.copy(svCamfeatureInfo->strValue, SV_STRING_SIZE);
    }

    else if(SV_intfIString == svCamfeatureInfo->featurInfo.type)
    {
        SVFeatureGetValueString(m_hRemoteDevice, hFeature, svCamfeatureInfo->strValue, SV_STRING_SIZE);
    }
    else if(SV_intfIEnumeration ==svCamfeatureInfo->featurInfo.type)
    {
        int64_t pInt64Value =0;
        SV_RETURN  ret = SVFeatureEnumSubFeatures(m_hRemoteDevice, hFeature, svCamfeatureInfo->featurInfo.enumSelectedIndex, svCamfeatureInfo->subFeatureName,sizeof(svCamfeatureInfo->subFeatureName)); //, &pInt64Value);

        std::string s(svCamfeatureInfo->subFeatureName);
        if ( sizeof(s) > 0)
            s.copy( svCamfeatureInfo->strValue, SV_STRING_SIZE);
        svCamfeatureInfo->intValue = pInt64Value;
    }
}

void SVCamFeature::getDeviceFeatureList(SV_FEATURE_VISIBILITY visibility)
{
    DSDeleteContainer(m_featureInfolist);
    uint32_t iIndex = 0;
    SV_RETURN ret =  SV_ERROR_SUCCESS;

    while(true)
    {
        SV_FEATURE_HANDLE hFeature = NULL;
        ret = SVFeatureGetByIndex(m_hRemoteDevice,iIndex++ , &hFeature);
        if(SV_ERROR_SUCCESS != ret)
            break;

        // create a new feature structure
        SVCamFeatureInfo *camFeatureInfo = new SVCamFeatureInfo();

        ret = SVFeatureGetInfo(m_hRemoteDevice, hFeature, &camFeatureInfo->featurInfo);
        if(SV_ERROR_SUCCESS != ret)
        {
            continue;
        }

        // retrieve only a specific features
        if(camFeatureInfo->featurInfo.visibility > visibility || !camFeatureInfo->featurInfo.isImplemented || SV_intfIPort == camFeatureInfo->featurInfo.type)
        {
            delete camFeatureInfo;
            continue;
        }

        // get the current value and feature info
        getFeatureValue(hFeature, camFeatureInfo);

        //add the feature handle and remote device handle
        camFeatureInfo->hFeature = hFeature;
        camFeatureInfo->hRemoteDevice = m_hRemoteDevice;
        m_featureInfolist.push_back(camFeatureInfo);
    }
}

SV_RETURN SVCamFeature::RegisterInvalidateCB(char* featureName, SV_CB_OBJECT objCb,SV_CB_FEATURE_INVALIDATED_PFN2 pfnFeatureInvalidateCb)
{
    SV_FEATURE_HANDLE hFeature = NULL;
    SV_RETURN ret = SVFeatureGetByName(m_hRemoteDevice, featureName, &hFeature);
    if(SV_ERROR_SUCCESS != ret)
        return  ret;

    ret  = SVFeatureRegisterInvalidateCB2(m_hRemoteDevice, hFeature, objCb, pfnFeatureInvalidateCb);
    return ret;
}

SV_RETURN SVCamFeature::UnRegisterInvalidateCB(SV_FEATURE_HANDLE hFeature)
{
    return SVFeatureUnRegisterInvalidateCB(m_hRemoteDevice, hFeature);
}

void SVCamFeature::printFeatureList()
{
    printf("--------------------------------------------------------------------\n");
    printf("******************Camera Feature Info*****************\n");
    printf(" ");
    for(std::vector<SVCamFeatureInfo*>::iterator i = m_featureInfolist.begin()+1; i != m_featureInfolist.end(); i++)
    {
        printf("|");
        for (int j =0; j <(*i)->featurInfo.level; j++)
            printf("--");

        printf((*i)->featurInfo.displayName);
        printf( ": "); printf( (*i)->strValue);printf( "\n ");
    }
    printf("--------------------------------------------------------------------\n");
}
