// ConsoleApplication1.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "string.h"
#include <math.h>

struct DATA_RGB {
	int red;
	int green;
	int blue;
};
struct DATA_LAB {
	int LInt8bit;
	int aInt8bit;
	int bInt8bit;
};
struct DATA_LAB_UNSIGNED {
	unsigned char LInt8bit;
	unsigned char aInt8bit;
	unsigned char bInt8bit;
};
struct DATA_LAB_SIGNED {
	signed char LInt8bit;
	signed char aInt8bit;
	signed char bInt8bit;
};

int convertLabToRgb(DATA_LAB dataLab, void* dataRgb)
{
	int retval = 0;
	double rLin, gLin, bLin;
	DATA_RGB *datRgb;

	datRgb = (DATA_RGB*)dataRgb;

	rLin = (5.06207e-8 * pow((-27.5862 + dataLab.bInt8bit - 0.676133*dataLab.LInt8bit), 3)) - \
		(6.24694e-8 * pow((40.8 + 1.0*dataLab.LInt8bit), 3)) + \
		(2.41719e-8 * pow((68.9655 + dataLab.aInt8bit + 1.69033*dataLab.LInt8bit), 3));
	gLin = (-3.4569e-9 * pow((-27.5862 + dataLab.bInt8bit - 0.676133*dataLab.LInt8bit), 3)) + \
		(7.40312e-8 * pow((40.8 + 1.0*dataLab.LInt8bit), 3)) - \
		(7.54907e-9 * pow((68.9655 + dataLab.aInt8bit + 1.69033*dataLab.LInt8bit), 3));
	bLin = (-1.44965e-7 * pow((-27.5862 + dataLab.bInt8bit - 0.676133*dataLab.LInt8bit), 3)) - \
		(8.85045e-9 * pow((40.8 + 1.0*dataLab.LInt8bit), 3)) + \
		(5.55981e-10 * pow((68.9655 + dataLab.aInt8bit + 1.69033*dataLab.LInt8bit), 3));
	if (rLin > 1) rLin = 1.0;
	else if (rLin < 0) rLin = 0.0;
	else if (rLin < 0.0031308) rLin *= 12.92;
	else rLin = 1.055 * pow(rLin, 1.0 / 2.4) - 0.055;

	if (gLin > 1) gLin = 1.0;
	else if (gLin < 0) gLin = 0.0;
	else if (gLin < 0.0031308) gLin *= 12.92;
	else gLin = 1.055 * pow(gLin, 1.0 / 2.4) - 0.055;

	if (bLin > 1) bLin = 1.0;
	else if (bLin < 0) bLin = 0.0;
	else if (bLin < 0.0031308) bLin *= 12.92;
	else bLin = 1.055 * pow(bLin, 1.0 / 2.4) - 0.055;

	(*datRgb).red = (round(rLin * 255));
	(*datRgb).green = (round(gLin * 255));
	(*datRgb).blue = (round(bLin * 255));


	return retval;
}

void convertLabSigned(DATA_LAB_UNSIGNED in, DATA_LAB_SIGNED* out)
{

	printf("ConvertLabSigend Input: %x %x %x\n", in.aInt8bit, in.bInt8bit, in.LInt8bit);
	out->aInt8bit = in.aInt8bit;
	out->bInt8bit = in.bInt8bit;
	out->LInt8bit = in.LInt8bit;
	printf("Output: %d %d %d\n", out->aInt8bit, out->bInt8bit, out->LInt8bit);
}



typedef struct
{
	unsigned short byteorder;
	unsigned short version_nr;
	long           offset;
} tif_hdr_type;
typedef struct
{
	unsigned short tag_nr;
	unsigned short type;
	long count;
	long offset;
} tag_type;

void change_tiff_tag(char *filename)
{
	printf("%s",filename);
	FILE *fp;
	tif_hdr_type tif_hdr;
	tag_type tifTag[100];
	unsigned short anz;
	int i;
	unsigned long next;

	fopen_s(&fp, filename, "rb+");
	fread(&tif_hdr, 1,sizeof(tif_hdr_type), fp);
	printf("offset:%lx\n", tif_hdr.offset);
	fseek(fp, tif_hdr.offset, SEEK_SET);
	if (fread(&anz, 1, sizeof(anz), fp) != sizeof(anz))
	{
		printf("Can't read tag count.\n");
	};
	for (i = 0; i < anz; i++)
	{
		if (fread(&tifTag[i], 1, sizeof(tag_type), fp) != sizeof(tag_type))
		{
			printf("Cant't read tag number %d.\n", i);
		}
		printf("tag %d: %x,%x\n", i, tifTag[i].tag_nr, tifTag[i].offset);
		if (tifTag[i].tag_nr == 0x106)
			break;
	}
	tifTag[i].offset = 8;
	fseek(fp, tif_hdr.offset+2+i*sizeof(tag_type), SEEK_SET);
	fwrite(&tifTag[i],1,sizeof(tag_type),fp);
	fclose(fp);
	return;
}

int main()
{
	 //Beispielaufruf Convertierung LAB to RGB
	DATA_RGB testRgb;
	DATA_LAB testLab;
	DATA_LAB_UNSIGNED testUnsigned;
	DATA_LAB_SIGNED testSigned;
	testLab.LInt8bit = 255;
	testLab.aInt8bit = 0;
	testLab.bInt8bit = 0;
	convertLabToRgb(testLab, &testRgb);
	printf("input:255,0,0\n");
	printf("erg:%d,%d,%d\n", testRgb.red, testRgb.green, testRgb.blue);
	testLab.LInt8bit = 180;
	testLab.aInt8bit = 50;
	testLab.bInt8bit = -20;
	convertLabToRgb(testLab, &testRgb);
	printf("input:180,50,-20\n");
	printf("erg:%d,%d,%d\n", testRgb.red, testRgb.green, testRgb.blue);

	//Beispielaufruf Convertierung LAB to RGB
	char filename[200] = "d:\\projects\\ConvertLabRgb\\GrauRampeInLAB.tif";
	change_tiff_tag(filename);


	//Beispielaufruf Convertierung unsigned LAB to RGB (signed)
	testUnsigned.aInt8bit = 0xFF;
	testUnsigned.bInt8bit = 127;
	testUnsigned.LInt8bit = 10;
	convertLabSigned(testUnsigned, &testSigned);

	// Programmende
	getchar();
	return 0;
}

