<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:tns="hsi_schema" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:altova="http://www.altova.com">
	<xsl:output version="1.0" method="html" indent="no" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
	<xsl:param name="SV_OutputFormat" select="'HTML'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:template match="/">
		<html>
			<head>
				<title/>
			</head>
			<body>
				<h1>
					<span style="font-weight:bold; ">
						<xsl:text>CST names related to native HSI-commands </xsl:text>
					</span>
				</h1>
				<br/>
				<xsl:for-each select="$XML">
					<table border="1">
							<xsl:for-each select="tns:HSI_COMMANDS">
								<xsl:for-each select="CMD">
									<thead>
										<tr>
											<th width="284">
												<span>
													<xsl:text>CST Name</xsl:text>
												</span>
											</th>
											<th>
												<span>
													<xsl:text>Tag name</xsl:text>
												</span>
											</th>
											<th width="69">
												<span>
													<xsl:text>Tag ID</xsl:text>
												</span>
											</th>
											<th width="7">
												<span>
													<xsl:text>Number of elements</xsl:text>
												</span>
											</th>
											<th width="91">
												<span>
													<xsl:text>Tag type</xsl:text>
												</span>
											</th>
										</tr>
									</thead>
									<render style="font-style:italic;" >
									<tbody> 
										<tr>
											<td>
													<strong>Command: </strong>
													<strong>
														<xsl:value-of select="./@ID"/> 
													</strong>
											</td>
										</tr>
									</tbody>
									</render>
									<tbody>
										<xsl:for-each select="SETUP_NAME">
											<tr>
												<td width="284">
													<xsl:for-each select="@NAME">
														<span>
															<xsl:value-of select="string(.)"/>
														</span>
													</xsl:for-each>
												</td>
												<td>
													<xsl:for-each select="TAG_NAME">
														<xsl:apply-templates/>
													</xsl:for-each>
												</td>
												<td width="69">
													<xsl:for-each select="TAG_ID">
														<xsl:apply-templates/>
													</xsl:for-each>
												</td>
												<td width="7">
													<xsl:for-each select="NO_OF_ELEMENTS">
														<xsl:apply-templates/>
													</xsl:for-each>
												</td>
												<td width="91">
													<xsl:for-each select="TAG_TYPE">
														<xsl:apply-templates/>
													</xsl:for-each>
												</td>
											</tr>
									</xsl:for-each>
									</tbody>
									<tbody> 
											<text> .&#10; </text>
									</tbody>
									<tbody> 
											<text> .&#10; </text>
									</tbody>
								
								</xsl:for-each>
							</xsl:for-each>
					</table>
					<br/>
				</xsl:for-each>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
