/**********************************************************************/
// Project: Firmware KAx
// MODUL:   ka4hsi.h
// AUTOR:   B. Frei
//
// Contains Defines for interpreting HSI-Orders and building
// HSI-Responses
/**********************************************************************/

/***** Common constants ******************************************/
#define MAX_RSP_LNG 2048

//***** Common HSI Constants ************************************************/
/* Tag-Ids for Input Parameters */
#define TAG_FOB         0x001
#define TAG_FOH         0x002
#define TAG_BELEGSEITE      0x003
#define TAG_AUFL_PHYS       0x004
#define TAG_AUFLOESUNG      0x005
#define TAG_BILDAUSSCHNITT  0x006
#define TAG_BINAER_CONT     0x100
#define TAG_BINAER_CONT_2   0x101
#define TAG_BIN_COMP        0x110
#define TAG_BIN_SCHWELLE    0x111
#define TAG_BIN_FILLORDER   0x113
#define TAG_GRAU_CONT       0x200
#define TAG_GRAU_CONT_2     0x201
#define TAG_FARB_CONT       0x300
#define TAG_FARB_CONT_2     0x301
#define TAG_WZEIT       0x401
#define TAG_PAVOR       0x402
#define TAG_STRIP_GROESSE   0x403
#define TAG_JPEG_COMP       0x404
#define TAG_FILTER_KENN     0x500
#define TAG_HELLIGKEIT      0x502   // Renamed:
#define TAG_HELLIGKEIT_GRAU 0x502
#define TAG_SHADING_OFF     0x510
#define TAG_PAR_IV      0x520
#define TAG_TESTZEILE       0x600



#define TAG_VORDERSEITE     0
#define TAG_RUECKSEITE      1
#define TAG_SEITE_V_R       2

#define TAG_FILLORD_NORM    0
#define TAG_FILLORD_REV     1

#define TAG_AUFL_PHYS_STD      150
#define TAG_AUFL_PHYS_STD_MBL  200
#define DPI150          150
#define DPI200          200
#define DPI300          300
#define DPI400          400
#define DPI100          100
#define H_STANDARD      0
#define H_HELLER        1
#define H_DUNKLER       2

#define KA4_1_FBG_IDENTIFIER 0x4B31

#define TAG_SET_GAIN        0x1c0
#define TAG_SET_POINT_WHITE_REFERENCE 0x1C2
#define TAG_ACTUAL_WHITE_REFERENCE 0x1C3
#define TAG_SET_GAIN_WARN_LEVEL 0x1c4
#define TAG_SET_MINIMUM_GAIN_LEVEL 0x1C5
// #define TAG_GAIN_STARTVALUE 0x1c6
#define TAG_OFFSET_STARTVALUE 0x1c7
#define TAG_BLACK_ROUGH_STARTVALUE 0x1c8
#define TAG_BLACK_ROUGH_ACTUAL 0x1c9
#define TAG_ERROR           0x1CA
#define TAG_STATUS          0x1CB

//#define TAG_USED_SETTINGS   0x1CC

#define TAG_DF1_KONFIG      0x021
#define TAG_DF2_KONFIG      0x022
#define TAG_BETRIEBSZUSTAND 0x103
#define TAG_BETRIEBSZUSTAND_LED_MODUL 0x104
#define TAG_KONF_FIRMWARE   0x107
#define TAG_KONF_PROGRAMM_TEXT 0x109


#define ZUSTAND_DEFECT      0
#define ZUSTAND_READY       1
#define ZUSTAND_WARM_UP     2


//New KA-Tags
#define TAG_KA4_1_KONFIG      0x200
#define TAG_KA4_1_SETTING     0x208

#define TAG_KONF_HW_KA4        0x210
#define TAG_KONF_LOGIC_KA4     0x211
#define TAG_SENSOR_TYPE        0x212
#define TAG_HSI_LEVEL          0x213
#define TAG_KONF_HW2           0x214

#define TAG_USE_WHITECONTROL   0x200
#define TAG_USE_CORRECTEXPOSURE   0x221
#define TAG_SET_TESTPATTERN_MODE  0x222

//#define TAG_SET_HORIZONTAL_WREF_START_ABSOLUTE  0x223 renamed, see below
#define TAG_SET_HORIZONTAL_POSWREF_ABSOLUTE 0x223

#define TAG_SET_HORIZONTAL_WREF_LENGTH 0x224
#define TAG_USE_CHECKWHITE        0x225
#define TAG_SHOW_WHITEREF_BORDERS 0x226
//#define TAG_USE_WHITECONTROL_ENABLE_INPUT 0x227 renamed, see below
#define TAG_USE_WHITECONTROL_DISABLE_INPUT 0x227
#define TAG_SET_AVERAGEMODE       0x228
#define TAG_SET_GAMMAVALUE        0x229
#define TAG_USE_SHADING_CORRECTION 0x22a
#define TAG_USE_BLACKLEVEL_CORRECTION 0x22b
//#define TAG_USE_COLORLOOKUPTABLE  0x22c renamed, see below
#define TAG_USE_TAG_USE_COLOR_CONVERSION 0x22c
#define TAG_USE_DEINTERLEAVEMODE  0x22D
//#define TAG_USE_HIGHLEVEL_FOR_DISABLEWHITECONTROL 0x22E
#define TAG_USE_FASTINCREMENTAL_AT_WARMINGUP  0x22F
#define TAG_SET_VSYSTART       0x230
#define TAG_SET_VSYLENGTH      0x231
#define TAG_SET_HSYSTART       0x232
#define TAG_SET_HSYLENGTH      0x233
#define TAG_SET_SCANLINEREDUCTION 0x234
#define TAG_SET_INTEGRATION_TIME  0x235

#define TAG_USE_SCANCONDITION    0x236
#define TAG_SET_SCANPATTERN   0x237
#define TAG_SET_TRANSITIONS_PER_LINE 0x238
#define TAG_SET_RGB_LINE_DELAY  0x239
#define TAG_SET_SCANDIR         0x23A
#define TAG_USE_EXTERNAL_SYNC   0x23B
#define TAG_SET_SCAN_READY      0x23C
#define TAG_SET_STOPBYTRIGOVERRUN 0x23D
#define TAG_USE_HSY_DITHERGENERATOR  0x23E

#define TAG_SEL_EXT_SYNC_SRC   0x23F
#define TAG_BURN_SETTINGS      0x240
#define TAG_SET_ACTIVE_SETTING 0x241
#define TAG_POWER_DOWN         0x242

#define TAG_PHYS_AUFLOES_HOR  0x243
#define TAG_PHYS_AUFLOES_VERT 0x244
#define TAG_ZUSTAND_EXT_INPUT 0x245
#define TAG_MIRROR_DATA_HOR   0x246
#define TAG_COMMENT           0x247
#define TAG_SEL_SENSOR        0x248
#define TAG_COMMENT_LOADED_FILTER 0x249
#define TAG_SET_INTEGRATION_TIME_IN_NS 0x24A
#define TAG_SET_SCANCONDITION 0x24b
#define TAG_SET_WHITECONTROL_MODE_OLDTAGID 0x24c
#define TAG_USE_CONTINUOUS_LEDCONTROL 0x24d

#define TAG_SET_REGISTER      0x250
#define TAG_MOTORCONTROL      0x251
#define TAG_STATUS_MOTORCONTROL 0x252
#define TAG_GET_TIME_PER_PIXEL 0x253
#define TAG_SET_EXTERNAL_SIGNALS 0x254 // obsolete >= Ka6

#define TAG_LOGIC_DESCR_TEXT   0x255

#define   TAG_BACKSIDE_SETTING_OFFSET 0x256
#define TAG_GET_USED_SETTINGS        0x257
#define   TAG_SET_SETTING_STOREFLAG   0x258
#define TAG_PACKET_VERIFY 0x259

#define TAG_SET_CCDPARAMETER  0x260
#define TAG_CONFIG_EXTERNAL_SIGNALS 0x261 // obsolete >= Ka6
#define TAG_SET_SERIALNUMBER_PART1  0x262
#define TAG_SET_SERIALNUMBER_PART2  0x263
#define TAG_SET_CAMERA_DESCRIPTION_TEXT 0x264
#define TAG_SET_VIDEOOUT_MODE 0x265
#define TAG_SET_PRIVATE_DATA  0x266
#define TAG_SET_INITIAL_GAIN_LEVEL   0x267
#define TAG_UPDATA_INITIAL_GAIN      0x268
#define TAG_SELECT_COLOR_LUT    0x269
#define TAG_AUTOSET_NUMBER_SCANLINES 0x270
#define TAG_SET_MAX_NUMBER_SCANLINES 0x271
#define TAG_STOP_BY_MAX_NUMBER_SCANLINES 0x272
#define TAG_SET_VSY_OVERSIZE   0x273
#define TAG_GET_MININTTIME     0x274
#define TAG_GET_STATUS_EXT_OUTPUT 0x275
#define TAG_USE_DISTORTION_CORR_TABLE 0x276
#define TAG_GET_ACTIVE_CHANNELS 0x277
#define TAG_SET_TRIGG_IGNORE_COUNT 0x278
#define TAG_SYNCMODE_EXTENDED 0x279
#define TAG_DEST_GAIN_LEDCONTROL 0x27A
#define TAG_GET_CURRENT_SPEED_MODE  0x27B
#define TAG_SETTING_VERIFY  		0x27c
#define TAG_SEL_REFERENCEDATA_BLACK 0x280
#define TAG_SEL_REFERENCEDATA_WHITE 0x281
#define TAG_USE_GAIN_CORR_TABLE 	0x282
#define TAG_SET_WHITEREF_AVERAGE 0x283
#define TAG_SET_GAIN_CORR_VALUES 0x284
#define TAG_USE_WHITEREFVALUES_WITHOUT_OFFSETCORRECTION 0x285

#define TAG_SET_FIRSTWHITEREFPIXEL_SECPOS 0x286
#define TAG_SEL_WHITEREFPOS 0x287
#define TAG_SET_MAX_DIFF_TO_SECPOS 0x288

#define TAG_SET_REFERENCE_PARAMETER 0x289
#define TAG_GET_SYNCINTEGRATION_TIME 0x290
#define TAG_IMAGECOUNTER 0x291
#define TAG_GET_ENVIRONMENT_INFO 0x292
#define TAG_SET_INSERTMODE 0x293
#define   TAG_SET_REFERENCE_DATA_OFFSET 0x294

#define TAG_MUX_OUT_COLOR_SELECT      0x0295
#define   TAG_R_B_CHANGE               0x0296
#define   TAG_ENABLE_DDR               0x0297
#define TAG_VERT_SCAN_LINE_REDUCTION_PATTERN_LENGTH 0x0298
#define TAG_VERT_SCAN_LINE_PATTERN      0x0299
#define TAG_SET_BINNING 0x029A
#define TAG_LAST_ACTIVE_PIXEL 0x29B
#define TAG_REGISTER_TO_SETTING 0x29D
#define TAG_SYNCMODE_SPEEDRANGE 0x29E
#define TAG_SPEEDRANGE_VIDEOCORRECTION 0x29F
#define TAG_SET_HSYSTARTOFFSET 0x2A0
#define TAG_SET_HORIZONTAL_WREF_START 0x2A1
#define	TAG_SET_VERTICAL_WREF_START  0x2A3
#define TAG_SET_VERTICAL_WREF_LENGTH 0x2A4
#define TAG_SET_GAIN_STOP_FACTOR 0x2A5
#define TAG_SET_WREF_VISIBLE_MODE 0x2A6
#define TAG_SETTING_CLEAR 0x2a7
#define TAG_SET_VERTICAL_WREF_START_ABSOLUTE 0x2a8
#define TAG_COLUMN_INSERTMODE  0x2B0
#define TAG_SET_AP_GROUP   0x2B1
#define TAG_AP_TARGET_VIDEO_LEVEL 0x2B2
#define TAG_USE_WOBBEL_INTEGRATIONTIME 0x2b3
#define TAG_VAR_ENCODER_MININTTIME_FACTOR 0x2b4
#define TAG_GET_MASTERSLAVE_MODE 0x2b5


// Copenhagen ------------------------------------
#define TAG_SIM_CONF            0x300
#define TAG_SET_ODD_EVEN_SHIFT      0x301
#define TAG_LOAD_FIR_DIRECT         0x302
#define TAG_SET_TRUE_RES         0x303
#define TAG_LOAD_FIR_CONFIG         0x304
#define TAG_SET_COLOR_WEIGHTS      0x305
#define TAG_SET_IP_FILTER_VERT      0x306
#define TAG_SET_IP_FILTER_HOR      0x307
#define TAG_SET_DESTAG            0x308
#define TAG_SET_NEIGHBOURHOOD_RGN_1_STRT   0x309
#define TAG_SET_NEIGHBOURHOOD_RGN_2_STRT   0x30A
#define TAG_SET_NEIGHBOURHOOD_COUPLING      0x30B

#define  TAG_SET_LINEDISTANCE_OFFSET   0x30C
#define TAG_USE_TRUE_RESOLUTION      0x30D
#define  TAG_SET_SUPPRESSED_LINES 0x030e
#define TAG_SET_TRACE_MASK         0x30F

#define TAG_LED_CONTROL             0x310
#define TAG_SET_LED_START_DUTYCYCLE 0x311
#define TAG_LED_CURRENT_DUTYCYCLE   0x312

#define TAG_USER_SPECIFIC_IO_CONFIGURATION 0x313 // obsolete >= Ka71
//#define TAG_OFFSET_CORRECTION       0x314
#define TAG_VIDEOLEVEL_CORRECTION   0x315
#define TAG_USE_IP_FILTER_HOR          0x316
#define TAG_MASTER_SLAVE_CONFIGURATION  0x317
#define TAG_SET_WHITECONTROL_MODE        0x318
#define TAG_SET_RGB_LINEDISTANCE 		0x319
#define TAG_ALIGNED_FILTER_PAR   0x320   /* CMD_DF */
#define TYPE_FILTER_PACKET_TEXT 0x321    /* CMD_DF, response PK */
#define TAG_SET_GREYOUTPUT_MODE    0x322
//#define TAG_SET_TESTPATTERN_LEVEL  0x323 renamed, see below
#define TAG_SET_TESTPATTERN_LEVEL  0x323
#define TAG_GET_CHECKSUM_DV	       0x324
#define TAG_GAINCONTROL_DISABLE_STATUS 0x325

#ifdef I_KA5
#define TAG_HWMONITOR_VOLTAGE_VANALOG 0x330
#define TAG_HWMONITOR_VOLTAGE_VCORE 0x331
#define   TAG_HWMONITOR_VOLTAGE_SUPPLY1_KA5 0x332
#define   TAG_HWMONITOR_VOLTAGE_SUPPLY2_KA5  0x333
#define   TAG_HWMONITOR_VOLTAGE_VACCD 0x334
#define   TAG_HWMONITOR_VOLTAGE_VIN_KA5 0x335
#define   TAG_HWMONITOR_TEMPERATURE_FPGA 0x336
#define   TAG_HWMONITOR_TEMPERATURE_BOARD_KA5  0x337
#endif

// Container for Serial Control LC16
#define CONTAINER_ALL_HC       0x340
#define CONTAINER_LED1_HC    0x341
#define CONTAINER_LED2_HC  0x342
#define   CONTAINER_LED3_HC  0x343
#define CONTAINER_LED4_HC  0x344

// TAGs for Serial Control LC16
#define TAG_SET_CURRENT 0x345
#define TAG_SET_DESIRED_VALUE 0x346
#define TAG_SET_LIGHT_COUPLING 0x347
#define TAG_SET_DACVALUE_TO_CURRENT  0x348
#define TAG_USE_CURRENTCONTROL 0x349
#define TAG_SET_ONMODE 0x34a
#define TAG_ENABLE_HICON 0x34b
#define TAG_SET_CURRENT_HC_A    0x034C
#define TAG_SET_CURRENT_HC_B    0x034D
#define TAG_HC_COMPENSATION_CURRENT 0x034E
#define TAG_HC_COMPENSATION_TEMP_MIN 0x034F
#define TAG_HC_COMPENSATION_TEMP_MAX 0x0350
#define TAG_HC_TEMP_SHUTDOWN    0x0351
#define TAG_SET_MINCURRENT 0x352
#define TAG_SET_MAXCURRENT 0x353
#define TAG_SET_INIT_CURRENT 0x354


#define   TAG_GET_CURRENT_HC 0x360
#define   TAG_GET_INTENSITY_HC 0x361
#define   TAG_GET_STATUS_HC 0x362
#define TAG_GET_TEMPERATURE_HC 0x363
#define TAG_GET_VERSION_HC 0x364
#define TAG_GET_ONSTATE_HC 0x365


#ifdef KA6or7
#define   TAG_HWMONITOR_VOLTAGE_VANALOG1 0x370
#define   TAG_HWMONITOR_VOLTAGE_VANALOG2 0x371
#define   TAG_HWMONITOR_VOLTAGE_VCORE 0x372
#define   TAG_HWMONITOR_VOLTAGE_SUPPLY1 0x373
#define   TAG_HWMONITOR_VOLTAGE_SUPPLY2  0x374
#define   TAG_HWMONITOR_VOLTAGE_SUPPLY3  0x375
#define   TAG_HWMONITOR_VOLTAGE_SUPPLY_CCD  0x376
#define   TAG_HWMONITOR_VOLTAGE_IN 0x377
#define   TAG_HWMONITOR_VOLTAGE_LED_ANODE 0x378
#define   TAG_HWMONITOR_VOLTAGE_LEDA 0x379
#define   TAG_HWMONITOR_VOLTAGE_LEDB 0x37a
#define   TAG_HWMONITOR_TEMPERATURE_POW  0x380
#define   TAG_HWMONITOR_TEMPERATURE_BOARD  0x381
#define   TAG_HWMONITOR_TEMPERATURE_SENS 0x382
#define   TAG_HWMONITOR_TEMPERATURE_LEDA  0x383
#define   TAG_HWMONITOR_TEMPERATURE_LEDB  0x384
#define	  TAG_HWMONITOR_VOLTAGE_ANALOG_CCD	  0x385
#define   TAG_STORE_ENV_PARAM             0x38F
#endif

#define TAG_CONFIGURE_EXTERNAL_SIGNALS_A   0x390 // obsolete >= Ka6
#define TAG_SET_EXTERNAL_SIGNALS_A         0x391 // obsolete >= Ka6
#define TAG_GET_EXTERNAL_SIGNALS_A         0x392
#define TAG_GET_TRANSPORT_SPEED       0x393
#define TAG_GET_FIRST_ACTIVE_PIXEL       0x394
#define TAG_GET_LAST_ACTIVE_PIXEL          0x395
#define TAG_GET_MAXIMUM_TRANSPORT_SPEED      0x396
#define TAG_USE_LINEARISATION_TABLE       0x397
#define TAG_LINEARISATION_TABLE_DESCRIPTION 0x398
#define TAG_USE_SPEEDMODECHANGEHYSTERESIS 0x399

#define TAG_SET_CDS_GAIN     			0x3A0
#define TAG_SET_CAMERALINK_INTERFACE 	0x3A1

#define TAG_SET_EXTERNAL_SIGNAL_ASSIGNMENT_OLD 0x700
#define TAG_SET_EXTERNAL_SIGNAL_ASSIGNMENT     0x701
#define TAG_SET_EXTERNAL_SIGNAL_ASSIGNMENT_REFRENCE 0x702


// Container for PA-Tags
#define TAG_KA4_1_CONT          0x900
#define TAG_KA4_2_CONT          0x901
#define TAG_KA4_3_CONT          0x902
#define TAG_KA4_4_CONT          0x903

// New PA-Tags for Firewire
#define TAG_IMG_GREY_CONT            0x0901
#define TAG_IMG_COLOR_CONT            0x0902
#define TAG_IMG_BIN_CONT            0x0903

#define TAG_RESOLUTION_HOR            0x0911
#define TAG_RESOLUTION_VERT            0x0912
#define TAG_KA_OUT_RES_VERT         0x916
#define TAG_KA_OUT_RES_HOR            0x919

#define TAG_SHC_SELECTION            0x091b
#define TAG_SELECT_KA4_SETTING         0x091a

#define TAG_USE_CURRENT_GAIN_VALUE      0x0920
#define OVERWRITE_SETTING_CONT         0x0921

// PA Tags for KA4
#define TAG_AUFLOES_HOR         0x911
#define TAG_AUFLOES_VERT        0x912
#define TAG_PIXEL_HOR           0x913

#define TAG_PIXEL_VERT          0x914
#define TAG_PIXEL_VERT_LONG      0x924

#define TAG_INTEGRATION_TIME    0x915
#define TAG_DOCUMENT_SPEED      0x916
#define TAG_RGB_LINE_DELAY      0x917
#define TAG_TRANSITIONS_PER_LINE 0x918

// BK Tags
#define TAG_MOTORPOS            0x940
#define TAG_MOTOR_ONOFF         0x941

#define TAG_POWER_SAVE_MODE      0x943
#define TAG_SWITCH_LIGHT      0x944

#define TAG_ADDITIONAL_OFFSET  0x945
#define TAG_ADDITIONAL_GAIN    0x946
#define TAG_CLEAR_ENCODER      0x947

#define TAG_SET_ACR_READY	   0x948
#define TAG_SET_ACR_ERROR      0x949
#define TAG_SET_GP_IO 		   0x950

// Parameters for direct AFE-Control KA4
#define TAG_CHANNEL_AFE        0x68F
#define TAG_OP_MODE_AFE        0x680

#define TAG_OUTPUT_MODE_AFE    0x681

#define TAG_POWERDOWN_MODE_AFE 0x682
#define TAG_BLACK_LEVEL_AFE    0x683
#define TAG_GAIN_LEVEL_AFE     0x684
#define TAG_DAC_LEVEL_AFE      0x685
#define TAG_DAC_MODE_AFE       0x686


#define HSI_BIN         0x01    /* Channel IDs for Command IA */
#define HSI_GRAU        0x02
#define HSI_FARB        0x03
#define HSI_BIN2        0x04
#define HSI_GRAU2       0x05
#define HSI_FARB2       0x06

#define START_TEST      0x01    /* For Test-SW (Order LB) */

